/*******************************************************
Filename		:  FA_HABITAT_RESULT_index.sql
Release 		:  1496
SIR			:  c2.0
Description		:  create indexes for the FA_HABITAT_RESULT fact table.
Author			:  Bill Nash
Date			:  7/08/2003
Comments		:  Created based on Regular Results
			   Removed index for fk_mad_hmethod and fk_mad_hdatum   WN
**********************************************************/

spool FA_HABITAT_RESULT_index.log
connect storetw/storetw@storet.sdc

--check where ihb_date was created before
create index ihb_date on FA_HABITAT_RESULT(fk_date_act_start)
tablespace storetindx
storage (initial 3M next 3M) nologging;

create index ihb_acitivty_isn on FA_HABITAT_RESULT(activity_isn)
tablespace storetindx
storage (initial 3M next 3M) nologging;


--FK INDEXES
create bitmap index ihb_org1 on FA_HABITAT_RESULT(fk_org)
tablespace storetindx
storage (initial 3M next 3M) nologging;

--create index ihb_mad_hmethod on FA_HABITAT_RESULT(fk_mad_hmethod)
--tablespace storetindx
--storage (initial 3M next 3M) nologging;

--create index ihb_mad_hdatum on FA_HABITAT_RESULT(fk_mad_hdatum)
--tablespace storetindx
--storage (initial 3M next 3M) nologging;

/**
--only 429 currently used, changed to bitmap 2-25
--was deleted due to performance problems with project 3-28
create bitmap index ihb_char on FA_HABITAT_RESULT(fk_char)
tablespace storetindx
storage (initial 50m next 50m) nologging;
**/

--changed to bitmap 2-25
create bitmap index ihb_geo1 on FA_HABITAT_RESULT(fk_geo_state)
tablespace storetindx
storage(initial 3M next 3M) nologging;

create index ihb_geo2 on FA_HABITAT_RESULT(fk_geo_county)
tablespace storetindx
storage(initial 3M next 3M) nologging;

create index ihb_db_cat on FA_HABITAT_RESULT(fk_db_cat)
tablespace storetindx
storage(initial 3M next 3M) nologging;

--use to be created in another script
create index ihb_station on FA_HABITAT_RESULT(fk_station)
tablespace storetindx
storage(initial 3M next 3M) nologging;


--ADDITIONAL COLUMN INDEXES
create index ihb_huc on FA_HABITAT_RESULT(hydrologic_unit_code)
tablespace storetindx
storage(initial 3M next 3M) nologging;

--changed to bitmap 1/28
create bitmap index ihb_oid on                             
FA_HABITAT_RESULT(organization_id)                   
tablespace storetindx                             
storage(initial 3M next 3M) nologging; 

--delete independent lat and long indexes?
create index ihb_lat_long on 
FA_HABITAT_RESULT(stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 3M next 3M) nologging;

--MULTI-DIMENSIONAL INDEXES
/**
create index ihb_lat_long_medium on 
FA_HABITAT_RESULT(stn_latitude,stn_longitude,fk_act_medium)
tablespace storetindx
storage(initial 50m next 50m) nologging;
**/

create index ihb_date_lat_long on 
FA_HABITAT_RESULT(fk_date_act_start,stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 3M next 3M) nologging;

/** order of index changed on 2-27, significantly better performance
create index ihb_lat_long_date_char on 
FA_HABITAT_RESULT(stn_latitude,stn_longitude,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 50m next 50m) nologging;
**/

create index ihb_char_date_lat_long on 
FA_HABITAT_RESULT(fk_char,fk_date_act_start,stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 3M next 3M) nologging;


create index ihb_state_date_char on 
FA_HABITAT_RESULT(fk_geo_state,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 3M next 3M) nologging;

--added 1/29
create index ihb_county_date_char on 
FA_HABITAT_RESULT(fk_geo_county,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 3M next 3M) nologging;

create index ihb_huc_date_char on 
FA_HABITAT_RESULT(hydrologic_unit_code,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 3M next 3M) nologging;

--added from performance_tuning script
create index ihb_pk_date_char on 
FA_HABITAT_RESULT(pk_isn,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 3M next 3M) nologging;

create index ihb_pk_char on 
FA_HABITAT_RESULT(pk_isn,fk_char)
tablespace storetindx
storage(initial 3M next 3M) nologging;

spool off;